﻿using HarmonyLib;
using RimWorld;
using Verse;

namespace Xoa
{
    public class Life_Stage_Change
    {
        [HarmonyPatch(typeof(Pawn_AgeTracker), nameof(Pawn_AgeTracker.CurLifeStage), MethodType.Getter)]
        static class Pawn_AgeTracker__CurLifeStage
        {
            /*
             * Gives out LifeStage as appropiate
             */
            static void Postfix(ref Pawn ___pawn, ref LifeStageDef __result)
            {
                if (___pawn.RaceProps.Humanlike && ___pawn.ageTracker != null && XoaHelper.IsXoaSized(___pawn))
                {
                    if (___pawn.ageTracker.AgeBiologicalYears >= 13)
                        __result = XoaHelper.lifeStageXoaAdult;
                    else
                        __result = XoaHelper.lifeStageXoaChild;
                }
            }
        }
    }
}
